% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.plink.run.r
\name{utils.plink.run}
\alias{utils.plink.run}
\title{Runs PLINK from within R}
\usage{
utils.plink.run(
  dir.in,
  plink.cmd = "plink",
  plink.path = "path",
  out = "hapmap1",
  syntax,
  verbose = NULL
)
}
\arguments{
\item{dir.in}{The path where the data files are}

\item{plink.cmd}{The 'name' to call plink. This will depend on the file name 
(without the extension '.exe' if on windows) or the name of the PATH variable}

\item{plink.path}{The path where the executable is. If plink is listed in
the PATH then there is no need for this. This is what the option "path"
means}

\item{out}{The root of the output file name}

\item{syntax}{the flags to pass to plink call}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default NULL].}
}
\value{
A character vector with the command used for PLINK.
}
\description{
Runs PLINK from within R.
}
\details{
PLINK needs to be installed on the 
  machine and syntax used need to be appropriate for the version installed.
}
\references{
Purcell, Shaun, et al. 'PLINK: a tool set for whole-genome association and
population-based linkage analyses.' The American journal of human genetics
81.3 (2007): 559-575.
}
\author{
Custodian: Carlo Pacioni and Luis Mijangos (Post to
 \url{https://groups.google.com/d/forum/dartr})
}
