% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subjects.R
\name{get_subjects}
\alias{get_subjects}
\title{Get a list of subjects covered in the data bank}
\usage{
get_subjects(
  subjects = NULL,
  recursive = FALSE,
  include_tables = FALSE,
  language = c("en", "da")
)
}
\arguments{
\item{subjects}{Provide specific subject id's to get subtopics. E.g. \code{subjects = c("02", "2419")}}

\item{recursive}{Whether subtopics/tables will be retrieved all the way down the hierarchy. Otherwise, only the closest level under the provided subjects will be retrieved. Default = \code{FALSE}}

\item{include_tables}{Whether the result should contain tables. Otherwise, only subjects are returned. Default = \code{FALSE}}

\item{language}{Language for the return object. Default = \code{"en"}}
}
\value{
A data frame
}
\description{
Get a list of subjects covered in the data bank
}
\examples{
# Get all subjects
all_subjects <- get_subjects()

# Or get (sub)subjects for specific subjects
some_subjects <- get_subjects(subjects = c("2", "3"))

# Get all subject hierarchy for a given subject
subject_with_hierarchy <- get_subjects(subjects = "2", recursive = TRUE)
}
