% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{gfilter}
\alias{gfilter}
\title{Generic function to filter either an igraph object or a PPI network}
\usage{
gfilter(
  method = NULL,
  g = NULL,
  val = NULL,
  use_ppi,
  igraph_method = NULL,
  n = 100,
  desc = TRUE,
  ...
)
}
\arguments{
\item{method}{str}

\item{g}{igraph object}

\item{val}{named numeric vector - some measure of node state (i.e. gene expression in the case of a PPI)}

\item{use_ppi}{bool - should we use a ppi from online repository?}

\item{igraph_method}{bool - is the user-provided method an igraph node scoring function?}

\item{n}{int - number of nodes to include in the returned subgraph}

\item{desc}{bool - do we want the top or bottom examples of the provided metric}

\item{...}{additional params passed to \code{\link[=load_ppi]{load_ppi()}} or \code{\link[=compute_crosstalk]{compute_crosstalk()}}}
}
\value{
igraph
}
\description{
Generic function to filter either an igraph object or a PPI network
}
\seealso{
\link{gfilter.ct}, \link{gfilter.np}, \link{gfilter.igraph_method}
}
