% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_null.R
\name{bootstrap_null}
\alias{bootstrap_null}
\title{Bootstrap null distribution for RWR}
\usage{
bootstrap_null(
  seed_proteins,
  g,
  n = 1000,
  agg_int = 100,
  gamma = 0.6,
  eps = 1e-10,
  tmax = 1000,
  norm = TRUE,
  set_seed = NULL,
  cache = NULL,
  seed_name = NULL,
  ncores = 1
)
}
\arguments{
\item{seed_proteins}{user defined seed proteins}

\item{g}{igraph object}

\item{n}{number of random walks with repeats to create null distribution}

\item{agg_int}{number of runs before we need to aggregate the results - necessary to save memory. set at lower numbers to save even more memory.}

\item{gamma}{restart probability}

\item{eps}{maximum allowed difference between the computed probabilities at the steady state}

\item{tmax}{the maximum number of iterations for the RWR}

\item{norm}{if True, w is normalized by dividing each value by the column sum.}

\item{set_seed}{integer to set random number seed - for reproducibility}

\item{cache}{A filepath to a folder downloaded files should be stored}

\item{seed_name}{Name to give the cached ngull distribution - must be a character string}

\item{ncores}{Number of cores to use - defaults to 1. Significant speedup can be achieved by using multiple cores for computation.}
}
\value{
data frame containing mean/ standard deviation for null distribution
}
\description{
This function will generate a bootstrapped null distribution to identify
signficant vertices in a PPI given a set of user-defined seed proteins.
Bootstrapping is done by performing random walk with repeats repeatedly over "random"
sets of seed proteins. Degree distribution of user-provided seeds is used to inform sampling.
}
\examples{
\donttest{
#g <- prep_biogrid()
#bootstrap_null(seed_proteins = c("EGFR", "KRAS"), g= g, ncores = 1, n = 10)
}
}
