% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-methods.R
\name{plot,PseudoDualSimulations,missing-method}
\alias{plot,PseudoDualSimulations,missing-method}
\title{Plot simulations}
\usage{
\S4method{plot}{PseudoDualSimulations,missing}(x, y, type = c("trajectory", "dosesTried", "sigma2"), ...)
}
\arguments{
\item{x}{the \code{\linkS4class{PseudoDualSimulations}} object we want
to plot from}

\item{y}{missing}

\item{type}{the type of plots you want to obtain.}

\item{\dots}{not used}
}
\value{
A single \code{\link[ggplot2]{ggplot}} object if a single plot is
asked for, otherwise a \code{\link{gridExtra}{gTree}} object.
}
\description{
Summarize the simulations with plots
}
\details{
This plot method can be applied to \code{\linkS4class{PseudoDualSimulations}}
objects in order to summarize them graphically. Possible \code{type}s of
plots at the moment are: \describe{ \item{trajectory}{Summary of the
trajectory of the simulated trials} \item{dosesTried}{Average proportions of
the doses tested in patients} \item{sigma2}{The variance of the efficacy responses}} 
You can specify one or both of these in the
\code{type} argument.
}
\examples{
##obtain the plot for the simulation results
##If DLE and efficacy responses are considered in the simulations
##Specified your simulations when no samples are used
## we need a data object with doses >= 1:
data <- DataDual(doseGrid=seq(25,300,25),placebo=FALSE)
##First for the DLE model 
##The DLE model must be of 'ModelTox' (e.g 'LogisticIndepBeta') class 
DLEmodel <- LogisticIndepBeta(binDLE=c(1.05,1.8),
                              DLEweights=c(3,3),
                              DLEdose=c(25,300),
                              data=data)

##The efficacy model of 'ModelEff' (e.g 'Effloglog') class 
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),
                    nu=c(a=1,b=0.025),data=data,c=0)

##The escalation rule using the 'NextBestMaxGain' class
mynextbest<-NextBestMaxGain(DLEDuringTrialtarget=0.35,
                            DLEEndOfTrialtarget=0.3)


##The increments (see Increments class examples) 
## 200\% allowable increase for dose below 300 and 200\% increase for dose above 300
myIncrements<-IncrementsRelative(intervals=c(25,300),
                                 increments=c(2,2))
##cohort size of 3
mySize<-CohortSizeConst(size=3)
##Stop only when 36 subjects are treated
myStopping <- StoppingMinPatients(nPatients=36)
##Now specified the design with all the above information and starting with a dose of 25

##Specified the design(for details please refer to the 'DualResponsesDesign' example)
design <- DualResponsesDesign(nextBest=mynextbest,
                              model=DLEmodel,
                              Effmodel=Effmodel,
                              stopping=myStopping,
                              increments=myIncrements,
                              cohortSize=mySize,
                              data=data,startingDose=25)
##Specify the true DLE and efficacy curves
myTruthDLE<- function(dose)
{ DLEmodel@prob(dose, phi1=-53.66584, phi2=10.50499)
}

myTruthEff<- function(dose)
{Effmodel@ExpEff(dose,theta1=-4.818429,theta2=3.653058)
}

## Then specified the simulations and generate the trial
##For illustration purpose only 1 simulation is produced (nsim=1). 
mySim <-simulate(object=design,
                 args=NULL,
                 trueDLE=myTruthDLE,
                 trueEff=myTruthEff,
                 trueNu=1/0.025,
                 nsim=1,
                 seed=819,
                 parallel=FALSE)

##plot the simulation results
print(plot(mySim))

##If DLE and efficacy samples are involved
##The escalation rule using the 'NextBestMaxGainSamples' class
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})
##The design of 'DualResponsesSamplesDesign' class
design <- DualResponsesSamplesDesign(nextBest=mynextbest,
                                     cohortSize=mySize,
                                     startingDose=25,
                                     model=DLEmodel,
                                     Effmodel=Effmodel,
                                     data=data,
                                     stopping=myStopping,
                                     increments=myIncrements)
##options for MCMC
options<-McmcOptions(burnin=10,step=1,samples=20)
##The simulations
##For illustration purpose only 1 simulation is produced (nsim=1). 
mySim<-simulate(design,
                args=NULL,
                trueDLE=myTruthDLE,
                trueEff=myTruthEff,
                trueNu=1/0.025,
                nsim=1,
                mcmcOptions=options,
                seed=819,
                parallel=FALSE)
##plot the simulation results
print(plot(mySim))
}
\keyword{methods}
