% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataParts-class}
\alias{DataParts-class}
\alias{.DataParts}
\title{Class for the data with two study parts}
\description{
This is a subclass of \code{\linkS4class{Data}}, so contains all
slots from \code{\linkS4class{Data}}, and in addition information on the two
study parts.
}
\section{Slots}{

\describe{
\item{\code{part}}{integer vector; which part does each of the patients belong to?}

\item{\code{nextPart}}{integer; what is the part for the next cohort?}

\item{\code{part1Ladder}}{sorted numeric vector; what is the escalation ladder for
part 1? This shall be a subset of the \code{doseGrid}.}
}}

\examples{
# create an object of class 'DataParts'
myData <- DataParts(x=c(0.1,0.5,1.5),
                    y=c(0,0,0),
                    doseGrid=c(0.1,0.5,1.5,3,6,
                               seq(from=10,to=80,by=2)),
                    part=c(1L,1L,1L),
                    nextPart=1L,
                    part1Ladder=c(0.1,0.5,1.5,3,6,10))
}
\keyword{classes}
