% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{Design-class}
\alias{Design-class}
\alias{.Design}
\title{Class for the CRM design}
\description{
In addition to the slots in the more simple \code{\linkS4class{RuleDesign}},
objects of this class contain:
}
\section{Slots}{

\describe{
\item{\code{model}}{the model to be used, an object of class
\code{\linkS4class{Model}}}

\item{\code{stopping}}{stopping rule(s) for the trial, an object of class
\code{\linkS4class{Stopping}}}

\item{\code{increments}}{how to control increments between dose levels,
an object of class \code{\linkS4class{Increments}}}

\item{\code{PLcohortSize}}{rules for the cohort sizes for placebo, if any planned
an object of class \code{\linkS4class{CohortSize}}}
}}

\examples{

# Define the dose-grid
emptydata <- Data(doseGrid = c(1, 3, 5, 10, 15, 20, 25, 40, 50, 80, 100))

# Initialize the CRM model 
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Choose the rule for selecting the next dose 
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Choose the rule for the cohort-size 
mySize1 <- CohortSizeRange(intervals=c(0, 30),
                           cohortSize=c(1, 3))
mySize2 <- CohortSizeDLT(DLTintervals=c(0, 1),
                         cohortSize=c(1, 3))
mySize <- maxSize(mySize1, mySize2)

# Choose the rule for stopping
myStopping1 <- StoppingMinCohorts(nCohorts=3)
myStopping2 <- StoppingTargetProb(target=c(0.2, 0.35),
                                  prob=0.5)
myStopping3 <- StoppingMinPatients(nPatients=20)
myStopping <- (myStopping1 & myStopping2) | myStopping3

# Choose the rule for dose increments
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))

# Initialize the design
design <- Design(model=model,
                 nextBest=myNextBest,
                 stopping=myStopping,
                 increments=myIncrements,
                 cohortSize=mySize,
                 data=emptydata,
                 startingDose=3)
  
  
}
\keyword{classes}
