% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingAny-class}
\alias{.StoppingAny}
\alias{StoppingAny-class}
\title{Stop based on fullfillment of any stopping rule}
\description{
This class can be used to combine multiple stopping rules with an OR
operator.
}
\details{
\code{stopList} contains all stopping rules, which are again objects of
class \code{\linkS4class{Stopping}}. Any of these rules must be fulfilled in
order that the result of this rule is to stop.
}
\section{Slots}{

\describe{
\item{\code{stopList}}{list of stopping rules}
}}
\examples{

# Define some stopping rules
myStopping1 <- StoppingMinCohorts(nCohorts=3)
myStopping2 <- StoppingTargetProb(target=c(0.2, 0.35),
                                  prob=0.5)
myStopping3 <- StoppingMinPatients(nPatients=20)

# Create a list of stopping rules (of class 'StoppingAny') which will then be
# summarized with the 'any' function, meaning that the study would be stopped if
# 'any' of the single stopping rules is TRUE.
mystopping <- StoppingAny(stopList=c(myStopping1,myStopping2,myStopping3))


}
\keyword{classes}

