% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_update_databases.R
\name{ct_update_databases}
\alias{ct_update_databases}
\title{Check for updates to country/commodity databases}
\usage{
ct_update_databases(force = FALSE, verbose = TRUE,
  commodity_type = c("HS", "HS1992", "HS1996", "HS2002", "HS2007", "HS2012",
  "SITC", "SITCrev1", "SITCrev2", "SITCrev3", "SITCrev4", "BEC", "EB02"),
  commodity_url = NULL, reporter_url = NULL, partner_url = NULL)
}
\arguments{
\item{force}{logical, if TRUE, both the country and commodity databases
will be downloaded, regardless of the status of the DB's on file. Default
value is FALSE.}

\item{verbose}{logical, if TRUE, an update status message will be printed
to console. Default value is TRUE.}

\item{commodity_type}{Trade data classification scheme to use, see
"details" for a list of the valid inputs. Default value is "HS", which is
the default "type" of the commodity database on file upon install of
\code{comtradr}. Please note that if the value passed to this arg doesn't
match the values in variable "type" of the current commodity DB, then
this function will replace the current commodity DB with that of the
type specified by this arg. If you don't intend to change the type of the
current commodity DB, then no input for this arg is required. To see
the "type" of the current commodity DB, use
\code{\link{ct_commodity_db_type}}.}

\item{commodity_url}{Default value NULL, otherwise this should be the base
url of the Comtrade json data directory. Only necessary if the Comtrade
site changes from "https://comtrade.un.org/data/cache/". This partial
url string will have a commodity extension appended to it to create a
valid url. The commodity extension will be chosen based on the input to
arg \code{commodity_type}.}

\item{reporter_url}{Default value NULL, otherwise this should be a url as a
char string that points to the reporter areas JSON dataset on the Comtrade
website. Only necessary if the Comtrade site changes from
\url{https://comtrade.un.org/data/cache/reporterAreas.json}}

\item{partner_url}{Default value NULL, otherwise this should be a url as a
char string that points to the reporter areas JSON dataset on the Comtrade
website. Only necessary if the Comtrade site changes from
\url{https://comtrade.un.org/data/cache/partnerAreas.json}}
}
\value{
Updated database of commodities and countries.
}
\description{
Use of the Comtrade API requires access to the Comtrade countries database
and commodities database. The \code{comtradr} package keeps each DB saved
as a data frame in the package directory, as Comtrade makes updates to
these DB's infrequently (roughly once per year).
}
\details{
This function will check to see if Comtrade has made any updates to either
database. If an update is found, it will download the updated DB and save
it to the \code{comtradr} package directory, and update the DB for use
within the current R session.

The default for arg \code{commodity_type} is \code{HS}. Below is a
 list of all valid inputs with a very brief description for each, for more
 information on each of these types, see
 \url{https://comtrade.un.org/data/doc/api/#DataAvailabilityRequests}
 \itemize{
 \item \code{HS}: Harmonized System (HS), as reported
 \item \code{HS1992}: HS 1992
 \item \code{HS1996}: HS 1996
 \item \code{HS2002}: HS 2002
 \item \code{HS2007}: HS 2007
 \item \code{HS2012}: HS 2012
 \item \code{SITC}: Standard International Trade Classification (SITC), as
   reported
 \item \code{SITCrev1}: SITC Revision 1
 \item \code{SITCrev2}: SITC Revision 2
 \item \code{SITCrev3}: SITC Revision 3
 \item \code{SITCrev4}: SITC Revision 4
 \item \code{BEC}: Broad Economic Categories
 \item \code{EB02}: Extended Balance of Payments Services Classification
 }
}
\examples{
\dontrun{
ct_update_databases()
}
}
