% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-indic.R
\name{GraphIndicatorsICM}
\alias{GraphIndicatorsICM}
\title{Graph Indicators of vertices by document (tidy data)}
\usage{
GraphIndicatorsICM(project, doc_id = "all")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{doc_id}{"all" (default) or the ID of document to include.}
}
\value{
A data frame (tidy data) with all indicators, their values by document (ICM)
}
\description{
Graph Indicators of vertices by document (tidy data)
}
\details{
Graph Indicators of vertices by document (tidy data)
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

GraphIndicatorsICM(my.project)
GraphIndicatorsICM(my.project, 2)
}
