## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----setup, message=FALSE-----------------------------------------------------
library(circumplex)

## -----------------------------------------------------------------------------
instruments()

## -----------------------------------------------------------------------------
instrument("csip")
print(csip)

## -----------------------------------------------------------------------------
instrument("isc")
print(isc)

## -----------------------------------------------------------------------------
instrument("ipipipc")
summary(ipipipc)

## -----------------------------------------------------------------------------
anchors(ipipipc)

## -----------------------------------------------------------------------------
norms(ipipipc)

## -----------------------------------------------------------------------------
scales(ipipipc, items = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  View(ipipipc)

## ----echo=FALSE, out.width='100%'---------------------------------------------
knitr::include_graphics("./view_ipipipc.png")

## -----------------------------------------------------------------------------
data("raw_iipsc")
print(raw_iipsc)

## -----------------------------------------------------------------------------
ips_iipsc <- ipsatize(data = raw_iipsc, items = 1:32, append = FALSE)
print(ips_iipsc)

## -----------------------------------------------------------------------------
round(rowMeans(raw_iipsc, na.rm = TRUE), 2)
round(rowMeans(ips_iipsc, na.rm = TRUE), 2)

## -----------------------------------------------------------------------------
instrument("iipsc")
scales(iipsc)

## -----------------------------------------------------------------------------
scale_scores <- score(
  data = raw_iipsc, 
  items = 1:32, 
  instrument = iipsc, 
  append = FALSE
)
print(scale_scores)

## -----------------------------------------------------------------------------
norms(iipsc)

## -----------------------------------------------------------------------------
z_scales <- norm_standardize(
  data = scale_scores, 
  scales = 1:8, 
  instrument = iipsc,
  sample = 1,
  append = FALSE
)
print(z_scales)

