% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoints.R
\docType{class}
\name{changepointsMod-class}
\alias{changepointsMod-class}
\alias{changepointsMod}
\title{An S4 class corresponding to the change-point model.}
\description{
An S4 class corresponding to the change-point model.
}
\section{Slots}{

\describe{
\item{\code{data}}{A list containing the data for the change-point model.
The exact structure of the data is dependent on the \code{bbmod}
and \code{log_likelihood} provided.  In cases where the data is
fairly simple, it should still be wrapped with a list, e.g.
X = list(X), to allow changepointsMod to handle it properly.}

\item{\code{part_values}}{A list containing the values estimated by
\code{bbmod}. \code{part_values}, in particular, contain values
that are updated independently for each partition (as opposed to
\code{whole_values}).}

\item{\code{whole_values}}{A list containing the values estimated by bbmod.
whole values, in particular, contain values that are shared
between partitions (as opposed to \code{part_values}).}

\item{\code{bbmod}}{An R function for performing the black-box estimation.}

\item{\code{bbmod_params}}{A list containing any additional parameters
for \code{bbmod}.}

\item{\code{log_likelihood}}{An R function for estimating the log-likelihood
for the corresponding \code{bbmod}.}

\item{\code{ll_params}}{A list containing any additional parameters for
\code{log_likelihood}.}

\item{\code{trace}}{A vector corresponding the the trace of the estimated
change-points based on the method used.}

\item{\code{changepoints}}{A scalar/vector corresponding to the changepoint(s)
estimated based on the method used.}

\item{\code{mod_list}}{A list corresponding to all the active single change-point
models used with \code{binary_segmentation}.}

\item{\code{mod_range}}{A list of the range of observations corresponding to each
active model for \code{binary_segmentation}.}
}}

\author{
\packageMaintainer{changepointsHD}
}
