% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildmultinom}
\alias{buildmultinom}
\title{Use \code{buildmer} to perform stepwise elimination for \code{multinom} models from package \code{nnet}}
\usage{
buildmultinom(formula, data = NULL, buildmerControl = buildmerControl(), ...)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{buildmerControl}{Control arguments for buildmer --- see the general documentation under \code{\link{buildmerControl}}}

\item{...}{Additional options to be passed to \code{multinom}; for backward-compatibility reasons, will also accept buildmer control parameters, although those specified in \code{buildmerControl} will take precedence}
}
\description{
Use \code{buildmer} to perform stepwise elimination for \code{multinom} models from package \code{nnet}
}
\examples{
if (requireNamespace('nnet') && require('MASS')) {
	options(contrasts = c("contr.treatment", "contr.poly"))
	example(birthwt)
	bwt.mu <- buildmultinom(low ~ age*lwt*race*smoke,bwt)
}
}
\seealso{
\code{\link{buildmer-package}}
}
