% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/not_in.R
\name{\%nin\%}
\alias{\%nin\%}
\alias{\%win\%}
\alias{\%wnin\%}
\title{Value matching}
\usage{
x \%nin\% table

x \%win\% table

x \%wnin\% table
}
\arguments{
\item{x}{Vector of values to be matched.}

\item{table}{Vector of values to be matched against.}
}
\value{
\verb{\%nin\%} returns a logical vector of the same length of \code{x}, indicating which values are not in \code{table}.

\verb{\%win\%} returns a sub-vector of \code{x} with the values that were found in \code{table}.

\verb{\%wnin\%} returns a sub-vector of \code{x} with the values that were not found in \code{table}.
}
\description{
\code{\%in\%} returns logical vector indicating values that do not have a match.
\verb{\%win\%} returns a vector of the values that have a match.
\verb{\%wnin\%} returns a vector of the values that do not have a match.
}
\examples{
vals <- c("a", "xa", "b")
vals \%nin\% letters
vals \%win\% letters
vals \%wnin\% letters
}
\seealso{
\code{\link[base:match]{base::match()}}
}
