% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{validate_newdata}
\alias{validate_newdata}
\title{Validate New Data}
\usage{
validate_newdata(newdata, object, re_formula = NULL,
  allow_new_levels = FALSE, resp = NULL, check_response = TRUE,
  incl_autocor = TRUE, all_group_vars = NULL, ...)
}
\arguments{
\item{newdata}{A \code{data.frame} containing new data to be validated.}

\item{object}{A \code{brmsfit} object.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{check_response}{Logical; Indicates if response variables should
be checked as well. Defaults to \code{TRUE}.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{all_group_vars}{Optional names of grouping variables to be validated.
Defaults to all grouping variables in the model.}

\item{...}{Currently ignored.}
}
\value{
A validated \code{'data.frame'} based on \code{newdata}.
}
\description{
Validate new data passed to post-processing methods of \pkg{brms}. Unless you
are a package developer, you will rarely need to call \code{validate_newdata}
directly.
}
