% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/hypothesis.R
\name{brmshypothesis}
\alias{brmshypothesis}
\alias{print.brmshypothesis}
\alias{plot.brmshypothesis}
\title{Descriptions of \code{brmshypothesis} Objects}
\usage{
\method{print}{brmshypothesis}(x, digits = 2, chars = 20, ...)

\method{plot}{brmshypothesis}(x, N = 5, ignore_prior = FALSE,
  chars = 40, colors = NULL, theme = NULL, ask = TRUE,
  plot = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{digits}{Minimal number of significant digits, 
see \code{\link[base:print.default]{print.default}}.}

\item{chars}{Maximum number of characters of each hypothesis
to print or plot. If \code{NULL}, print the full hypotheses.
Defaults to \code{20}.}

\item{...}{Currently ignored.}

\item{N}{The number of parameters plotted per page.}

\item{ignore_prior}{A flag indicating if prior distributions 
should also be plotted. Only used if priors were specified on
the relevant parameters.}

\item{colors}{Two values specifying the colors of the posterior
and prior density respectively. If \code{NULL} (the default)
colors are taken from the current color scheme of 
the \pkg{bayesplot} package.}

\item{theme}{A \code{\link[ggplot2:theme]{theme}} object 
modifying the appearance of the plots. 
For some basic themes see \code{\link[ggplot2:ggtheme]{ggtheme}}
and \code{\link[bayesplot:theme_default]{theme_default}}.}

\item{ask}{logical; indicates if the user is prompted 
before a new page is plotted. 
Only used if \code{plot} is \code{TRUE}.}

\item{plot}{logical; indicates if plots should be
plotted directly in the active graphic device.
Defaults to \code{TRUE}.}
}
\description{
A \code{brmshypothesis} object contains posterior samples
as well as summary statistics of non-linear hypotheses as 
returned by \code{\link[brms:hypothesis]{hypothesis}}.
}
\details{
The two most important elements of a \code{brmshypothesis} object are
\code{hypothesis}, which is a data.frame containing the summary estimates
of the hypotheses, and \code{samples}, which is a data.frame containing 
the corresponding posterior samples.
}
\seealso{
\code{\link[brms:hypothesis]{hypothesis}}
}
