% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{get_prior}
\alias{get_prior}
\title{Overview on Priors for \pkg{brms} Models}
\usage{
get_prior(
  formula,
  data,
  family = gaussian(),
  autocor = NULL,
  sparse = NULL,
  internal = FALSE,
  ...
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}

\item{family}{A description of the response distribution and link function to
be used in the model. This can be a family function, a call to a family
function or a character string naming the family. Every family function has
a \code{link} argument allowing to specify the link function to be applied
on the response variable. If not specified, default links are used. For
details of supported families see \code{\link{brmsfamily}}. By default, a
linear \code{gaussian} model is applied. In multivariate models,
\code{family} might also be a list of families.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing the
correlation structure within the response variable (i.e., the
'autocorrelation'). See the documentation of \code{\link{cor_brms}} for a
description of the available correlation structures. Defaults to
\code{NULL}, corresponding to no correlations. In multivariate models,
\code{autocor} might also be a list of autocorrelation structures.}

\item{sparse}{(Deprecated) Logical; indicates whether the population-level
design matrices should be treated as sparse (defaults to \code{FALSE}). For
design matrices with many zeros, this can considerably reduce required
memory. Sampling speed is currently not improved or even slightly
decreased. It is now recommended to use the \code{sparse} argument of
\code{\link{brmsformula}} and related functions.}

\item{internal}{A flag indicating if the names of additional internal
parameters should be displayed. Setting priors on these parameters is not
recommended}

\item{...}{Currently ignored.}
}
\value{
A data.frame with columns \code{prior}, \code{class}, \code{coef},
  and \code{group} and several rows, each providing information on a
  parameter (or parameter class) on which priors can be specified. The prior
  column is empty except for internal default priors.
}
\description{
Get information on all parameters (and parameter classes) for which priors 
may be specified including default priors.
}
\examples{
## get all parameters and parameters classes to define priors on
(prior <- get_prior(count ~ zAge + zBase * Trt + (1|patient) + (1|obs),
                    data = epilepsy, family = poisson()))   
         
## define a prior on all population-level effects a once
prior$prior[1] <- "normal(0,10)"

## define a specific prior on the population-level effect of Trt
prior$prior[5] <- "student_t(10, 0, 5)"       

## verify that the priors indeed found their way into Stan's model code
make_stancode(count ~ zAge + zBase * Trt + (1|patient) + (1|obs),
              data = epilepsy, family = poisson(), 
              prior = prior)

}
\seealso{
\code{\link{set_prior}}
}
