% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{cor_brms}
\alias{cor_brms}
\alias{cor_brms-class}
\title{Correlation structure classes for the \pkg{brms} package}
\description{
Classes of correlation structures available in the \pkg{brms} package. 
\code{cor_brms} is not a correlation structure itself, 
but the class common to all correlation structures implemented in \pkg{brms}.
}
\section{Available correlation structures}{

\describe{
  \item{cor_arma}{autoregressive-moving average (ARMA) structure, 
  with arbitrary orders for the autoregressive and moving
  average components}
  \item{cor_ar}{autoregressive (AR) structure of arbitrary order}
  \item{cor_ma}{moving average (MA) structure of arbitrary order} 
  \item{cor_arr}{response autoregressive (ARR) structure}
  \item{cor_car}{Spatial conditional autoregressive (CAR) structure}
  \item{cor_sar}{Spatial simultaneous autoregressive (SAR) structure}
  \item{cor_bsts}{Bayesian structural time series (BSTS) structure}
  \item{cor_fixed}{fixed user-defined covariance structure}
}
}

\seealso{
\code{\link[brms:cor_arma]{cor_arma}, \link[brms:cor_ar]{cor_ar},
      \link[brms:cor_ma]{cor_ma}, \link[brms:cor_arr]{cor_arr}, 
      \link[brms:cor_car]{cor_car}, \link[brms:cor_sar]{cor_sar},
      \link[brms:cor_bsts]{cor_bsts}, \link[brms:cor_fixed]{cor_fixed}}
}
