test_that("plotting functions don't throw unexpected errors", {
  fit <- brms:::rename_pars(brms:::brmsfit_example1)
  
  # plot.brmsfit
  expect_silent(p <- plot(fit, plot = FALSE))
  expect_silent(p <- plot(fit, pars = "^b", plot = FALSE))
  expect_silent(p <- plot(fit, pars = "^sd", plot = FALSE))
  expect_error(plot(fit, pars = "123"),  "No valid parameters selected")
  
  # stanplot.brmsfit
  expect_silent(p <- stanplot(fit))
  expect_silent(p <- stanplot(fit, pars = "^b"))
  expect_silent(p <- stanplot(fit, type = "trace", pars = "^b_"))
  expect_silent(p <- stanplot(fit, type = "hist", pars = "^sd_"))
  expect_silent(p <- stanplot(fit, type = "dens"))
  expect_silent(p <- stanplot(fit, type = "scatter",
                              pars = parnames(fit)[2:3], 
                              exact_match = TRUE))
  expect_silent(p <- stanplot(fit, type = "rhat", pars = "^b_"))
  expect_silent(p <- stanplot(fit, type = "neff"))
  expect_silent(p <- stanplot(fit, type = "acf"))
  expect_silent(p <- stanplot(fit, type = "nuts_divergence"))
  expect_error(stanplot(fit, type = "density"), "Invalid plot type")
  
  # pairs.brmsfit
  # uncomment as soon as bayesplot 1.2.0 is on CRAN
  # expect_s3_class(pairs(fit, pars = parnames(fit)[1:3]), "bayesplot_grid")
  
  # marginal_effects: manual checks of plotting method
  N <- 90
  marg_results <- data.frame(
    P1 = rpois(N, 20), 
    P2 = factor(rep(1:3, each = N / 3)),
    Estimate = rnorm(N, sd = 5), 
    Est.Error = rt(N, df = 10), 
    MargRow = rep(1:2, each = N / 2)
  )
  marg_results[["lowerCI"]] <- marg_results$Estimate - 2
  marg_results[["upperCI"]] <- marg_results$Estimate + 2
  marg_results <- list(marg_results[order(marg_results$P1), ])
  class(marg_results) <- "brmsMarginalEffects"
  attr(marg_results[[1]], "response") <- "count"
  # test with 1 numeric predictor
  attr(marg_results[[1]], "effects") <- "P1"
  marg_plot <- plot(marg_results, plot = FALSE)
  expect_true(is(marg_plot[[1]], "ggplot"))
  # test with 1 categorical predictor
  attr(marg_results[[1]], "effects") <- "P2"
  marg_plot <- plot(marg_results, plot = FALSE)
  expect_true(is(marg_plot[[1]], "ggplot"))
  # test with 1 numeric and 1 categorical predictor
  attr(marg_results[[1]], "effects") <- c("P1", "P2")
  marg_plot <- plot(marg_results, plot = FALSE)
  expect_true(is(marg_plot[[1]], "ggplot"))
})
