% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{macf}
\alias{macf}
\title{Autocorrelation Function Estimation based on MCMC-Samples (experimental)}
\usage{
macf(x, lag.max = NULL, plot = TRUE, ...)
}
\arguments{
\item{x}{A matrix, data.frame or numeric vector representing the time series. 
Each row is interpreted as a sample from an MCMC procedure, whereas the columns are taken to be points of a time series.
The colnames of x are taken to be the groups and it is assumed that observations can only correlate within each group.}

\item{lag.max}{Maximum lag at which to calculate the autocorrelation. 
Default is \code{10*log10(N/g)} where \code{N} is the number of observations and \code{g} the number of groups. 
Will be automatically limited to one less than the number of maximum observations within one group.}

\item{plot}{logical. If \code{TRUE} (the default) results are plotted directly}

\item{...}{Further arguments to be passed to \code{plot.acf}.}
}
\value{
An object of class \code{\link[stats:acf]{acf}}.
}
\description{
Compute (and plot by default) the autocorrelation function based on MCMC samples
}
\examples{
\dontrun{
## investigate the autorcorrelation in the residuals of a fitted model
## simulate data
set.seed(123)
phi <- c(0.4, 0.7, -0.3)
y <- 0
y[2] <- phi[1] * y[1] + rnorm(1)
y[3] <- phi[1] * y[2] + phi[2] * y[1] + rnorm(1)
for (i in 4:300) y[i] <- sum(phi * y[(i-1):(i-3)]) + rnorm(1)

## fit the model
fit1 <- brm(y ~ 1)
summary(fit1)

## investigate the residuals (autocorrelation clearly visible)
macf(residuals(fit1, summary = FALSE), lag.max = 10)

## fit the model again with autoregressive coefficients
fit2 <- brm(y ~ 1, autocor = cor_ar(p = 3))
summary(fit2)

## investigate the residuals again (autocorrelation is gone)
macf(residuals(fit2, summary = FALSE), lag.max = 10)
}
             
}

