% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/support.export.R
\name{brm.plot}
\alias{brm.plot}
\title{Trace and density plots for MCMC samples}
\usage{
brm.plot(fit, family = NA)
}
\arguments{
\item{fit}{An object of class \code{stanfit} or an object that can be coerced to an
\code{mcmc.list} via \code{as.mcmc} of package \code{coda}.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to
  be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).
  For details see the documentation of \code{ggmcmc}.}
}
\description{
Trace and density plots for MCMC samples using the \code{ggmcmc} package
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c, data = epilepsy,
           family = c("poisson", "log"))
brm.plot(fit)
}
}

