% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loaded.r
\docType{data}
\name{loaded}
\alias{loaded}
\alias{loaded_mods}
\alias{is_mod_loaded}
\alias{register_mod}
\alias{deregister_mod}
\alias{loaded_mod}
\alias{is_mod_still_loading}
\alias{mod_loading_finished}
\title{Environment of loaded modules}
\format{
\code{loaded_mods} is an environment of the loaded module and package
namespaces.
}
\usage{
loaded_mods

is_mod_loaded(info)

register_mod(info, mod_ns)

deregister_mod(info)

loaded_mod(info)

is_mod_still_loading(info)

mod_loading_finished(info, mod_ns)
}
\arguments{
\item{info}{the mod info of a module}

\item{mod_ns}{module namespace environment}
}
\description{
Each module is stored as an environment inside \code{loaded_mods} with the
module’s code location path as its identifier. The path rather than the
module name is used because module names are not unique: two modules called
\code{a} can exist nested inside modules \code{b} and \code{c}, respectively.
Yet these may be loaded at the same time and need to be distinguished.
}
\details{
\code{is_mod_loaded} tests whether a module is already loaded.

\code{register_mod} caches a module namespace and marks the module as loaded.

\code{deregister_mod} removes a module namespace from the cache, unloading
the module from memory.

\code{loaded_mod} retrieves a loaded module namespace given its info.

\code{is_mod_still_loading} tests whether a module is still being loaded.

\code{mod_loading_finished} signals that a module has been completely loaded.
}
\note{
\code{is_mod_still_loading} and \code{mod_loading_finished} are used to
break cycles during the loading of modules with cyclic dependencies.
}
\keyword{internal}
