% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupportingOpCharFunctions.R
\name{GroupMembershipMatrix}
\alias{GroupMembershipMatrix}
\title{Construct a group membership matrix for hierarchical algorithms}
\usage{
GroupMembershipMatrix(stage1, stage2 = NULL, stage3 = NULL, stage4 = NULL)
}
\arguments{
\item{stage1}{the group size in stage one of testing. This also corresponds
to the number of individuals to be tested and will specify the number of
columns in the resulting group membership matrix.}

\item{stage2}{a vector of group sizes in stage two of testing. The group sizes
specified here should sum to the number of individuals/group size specified
in \kbd{stage1}. If \kbd{NULL}, a group membership matrix will be constructed
for a two-stage hierarchical algorithm.
Further details are given under 'Details'.}

\item{stage3}{a vector of group sizes in stage three of testing. The group sizes
specified here should sum to the number of individuals/group size specified
in \kbd{stage1}. If group sizes are provided in \kbd{stage2} and \kbd{stage3}
is \kbd{NULL}, a group membership matrix will be constructed for a
three-stage hierarchical algorithm. Further details are given under 'Details'.}

\item{stage4}{a vector of group sizes in stage four of testing. The group sizes
specified here should sum to the number of individuals/group size specified
in \kbd{stage1}. If group sizes are provided in \kbd{stage3} and \kbd{stage4}
is \kbd{NULL}, a group membership matrix will be constructed for a four-stage
hierarchical algorithm. Further details are given under 'Details'.}
}
\value{
A matrix specifying the group membership for each individual. The
rows of the matrix correspond to the stages of testing and the columns of
the matrix correspond to the individuals to be tested.
}
\description{
Construct a group membership matrix for two-, three-, or
four-stage hierarchical algorithms.
}
\details{
This function constructs a group membership matrix for two-, three-,
four-, or five-stage hierarchical algorithms. The resulting group membership
matrix has rows corresponding to the number of stages of testing and columns
corresponding to each individual to be tested. The value specified in
\kbd{stage1} corresponds to the number of individuals to be tested.

For group membership matrices when only \kbd{stage1} is specified, a two-stage
hierarchical algorithm is used and the second stage will consist of individual
testing. For group membership matrices when \kbd{stage1} and \kbd{stage2} are
specified, a three-stage hierarchical algorithm is used and the third stage
will consist of individual testing. Group membership matrices for four- and
five-stage hierarchical algorithms follow a similar structure.
There should never be group sizes specified for later
stages of testing without also providing group sizes for all earlier stages
of testing (i.e., to provide group sizes for \kbd{stage3}, group sizes must
also be provided for \kbd{stage1} and \kbd{stage2}).
}
\examples{
# Generate a group membership matrix for a two-stage
#   hierarchical algorithm, within the opChar1() function
#   and calculate operating characteristics
opChar1(algorithm = "D2", p = 0.0193, Se = 0.99, Sp = 0.99,
        hier.config = GroupMembershipMatrix(stage1 = 16),
        print.time = FALSE)

# Generate a group membership matrix for a five-stage
#   hierarchical algorithm and calculate the
#   operating characteristics for a two-disease assay
config.mat <- GroupMembershipMatrix(stage1 = 16,
                                    stage2 = c(8,8),
                                    stage3 = c(4,4,4,4),
                                    stage4 = rep(2, times = 8))
Se <- matrix(data = rep(0.95, 10), nrow = 2, ncol = 5,
             dimnames = list(Infection = 1:2, Stage = 1:5))
Sp <- matrix(data = rep(0.99, 10), nrow = 2, ncol = 5,
             dimnames = list(Infection = 1:2, Stage = 1:5))
opChar2(algorithm = "D5", p.vec = c(0.92, 0.05, 0.02, 0.01),
        Se = Se, Sp = Sp, hier.config = config.mat)
}
\seealso{
Other operating characteristic functions: 
\code{\link{Sterrett}()},
\code{\link{TOD}()},
\code{\link{halving}()},
\code{\link{operatingCharacteristics1}()},
\code{\link{operatingCharacteristics2}()}
}
\author{
Minh Nguyen and Christopher Bilder
}
\concept{operating characteristic functions}
