% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyapp.R
\name{shiny_tracks}
\alias{shiny_tracks}
\title{Dynamically explore tracks within Shiny app}
\usage{
shiny_tracks(data, epsg)
}
\arguments{
\item{data}{A data frame that must contain columns labeled \code{id, x, y,
date}, but can include any other variables of interest.}

\item{epsg}{numeric. The coordinate reference system (CRS) as an EPSG code.}
}
\description{
This Shiny application allows for the exploration of individual movement
patterns, as well as those of all tracked individuals. Options are available
to interactively filter the plotted tracks by a selected time period of a
given variable. Additionally, collections of individuals can be plotted
simultaneously and these tracks can be filtered to only display movements
within a given period of time.
}
\details{
Currently, the time series plot shown for the exploration of individual
tracks cannot display variables of class \code{character} or \code{factor}.
Therefore, these should be changed to numeric values if they are to be
plotted.

If the data are stored as longitude and latitude (i.e., WGS84), the EPSG code
is 4326. All other codes will need to be looked up if they are not already
known.
}
\examples{
\dontrun{
#load data
data(tracks)

#run Shiny app
shiny_tracks(data = tracks, epsg = 32617)

}

}
