% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{filter_time}
\alias{filter_time}
\title{Filter observations for time interval of interest}
\usage{
filter_time(dat.list, int)
}
\arguments{
\item{dat.list}{A list of data associated with each animal ID where names of
list elements are the ID names.}

\item{int}{numeric. The time interval of interest.}
}
\value{
A list where observations for each animal ID (element) has been
  filtered for \code{int}. Two columns (\code{obs} and \code{time1}) are
  added for each list element (ID), which store the original observation
  number before filtering and the new observation number after filtering,
  respectively.
}
\description{
Selects observations that belong to the time interval of interest and removes
all others. This function also removes entire IDs from the dataset when there
is one or fewer observations at this time interval. This function works
closely with \code{\link{round_track_time}} to only retain observations
sampled at a regular time interval, which is important for analyzing step
lengths and turning angles. Column storing the time intervals must be labeled
\code{dt}.
}
\examples{
#load data
data(tracks)

#subset only first track
tracks<- tracks[tracks$id == "id1",]

#calculate step lengths and turning angles
tracks<- prep_data(dat = tracks, coord.names = c("x","y"), id = "id")

#round times to nearest interval of interest (e.g. 3600 s or 1 hr)
tracks<- round_track_time(dat = tracks, id = "id", int = 3600, tol = 180, time.zone = "UTC")

#create list from data frame
tracks.list<- df_to_list(dat = tracks, ind = "id")

#filter observations to only 1 hr (or 3600 s)
tracks_filt.list<- filter_time(dat.list = tracks.list, int = 3600)

}
