% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_ammi.R
\name{ge_ammi}
\alias{ge_ammi}
\alias{ge_ammi.default}
\title{AMMI of Genotype by Environment Interaction Model}
\usage{
ge_ammi(.data, .y, .gen, .env, .rep)

\method{ge_ammi}{default}(.data, .y, .gen, .env, .rep)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}

\item{.rep}{Replication Factor}
}
\value{
Genotype by Environment Interaction Model
}
\description{
Performs Additive Main Effects and Multiplication Interaction Analysis of Genotype by Environment Interaction Model
}
\examples{

data(Maiz)
fm1 <-
   ge_ammi(
      .data  = Maiz
     , .y    = y
     , .gen  = entry
     , .env  = site
     , .rep  = rep
     )




}
\references{
Crossa, J., Perez-Elizalde, S., Jarquin, D., Cotes, J.M., Viele, K., Liu, G., and Cornelius, P.L. (2011)
 Bayesian Estimation of the Additive Main Effects and Multiplicative Interaction Model
 \emph{Crop Science}, \strong{51}, 1458–1469.
 (\href{https://dl.sciencesocieties.org/publications/cs/abstracts/51/4/1458?access=0&view=pdf}{doi: 10.2135/cropsci2010.06.0343})
}
\author{
\enumerate{
    \item Muhammad Yaseen (\email{myaseen208@gmail.com})
   }
}
