% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_performance}
\alias{print.auditor_model_performance}
\title{Prints Model Performance Summary}
\usage{
\method{print}{auditor_model_performance}(x, ...)
}
\arguments{
\item{x}{an object \code{auditor_model_performance} created with \code{\link{model_performance}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Performance Summary
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
model_performance(glm_audit)

}
