% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_bmi.R
\name{compute_bmi}
\alias{compute_bmi}
\title{Compute Body Mass Index (BMI)}
\usage{
compute_bmi(height, weight)
}
\arguments{
\item{height}{HEIGHT value

It is expected that HEIGHT is in cm.

\emph{Permitted Values:} numeric vector}

\item{weight}{WEIGHT value

It is expected that WEIGHT is in kg.

\emph{Permitted Values:} numeric vector}
}
\value{
The BMI (Body Mass Index Area) in kg/m^2.
}
\description{
Computes BMI from height and weight
}
\details{
Usually this computation function can not be used with \verb{\%>\%}.
}
\examples{
compute_bmi(height = 170, weight = 75)
}
\seealso{
\code{\link[=derive_param_bmi]{derive_param_bmi()}}

BDS-Findings Functions that returns a vector: 
\code{\link{compute_bsa}()},
\code{\link{compute_egfr}()},
\code{\link{compute_framingham}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_rr}()},
\code{\link{compute_scale}()},
\code{\link{transform_range}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
