% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{event_source}
\alias{event_source}
\title{Create an \code{event_source} Object}
\usage{
event_source(dataset_name, filter = NULL, date, set_values_to = NULL)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} parameter
of \code{derive_param_tte()}.}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset} which are events or possible censoring time points.}

\item{date}{A variable providing the date of the event or censoring. A date,
or a datetime can be specified. An unquoted symbol is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{set_values_to}{A named list returned by \code{exprs()} defining the variables
to be set for the event or censoring, e.g. \code{exprs(EVENTDESC = "DEATH", SRCDOM = "ADSL", SRCVAR = "DTHDT")}. The values must be a symbol, a
character string, a numeric value, or \code{NA}.}
}
\value{
An object of class \code{event_source}, inheriting from class \code{tte_source}
}
\description{
\code{event_source} objects are used to define events as input for the
\code{derive_param_tte()} function.
}
\examples{
# Death event

event_source(
  dataset_name = "adsl",
  filter = DTHFL == "Y",
  date = DTHDT,
  set_values_to = exprs(
    EVNTDESC = "DEATH",
    SRCDOM = "ADSL",
    SRCVAR = "DTHDT"
  )
)
}
\seealso{
\code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=censor_source]{censor_source()}}

Source Objects: 
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event}()},
\code{\link{query}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
