% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{get_cps}
\alias{get_cps}
\title{Identify the Beginning of the Alarm Clusters}
\usage{
get_cps(alarms, w)
}
\arguments{
\item{alarms}{A numeric vector. The alarms raised during the monitoring process.}

\item{w}{An integer. The window size used to group alarms into clusters.}
}
\value{
A numeric vector containing the starting points of the alarm clusters.
If the next alarm is within \code{w} observations of the current alarm,
the next alarm will be considered part of the current alarm cluster.
Otherwise, a new cluster is formed and the next alarm is considered the beginning
of a new alarm cluster.
}
\description{
This function clusters alarms into groups and identifies the starting points of the alarm clusters.
If the next alarm occurs within a specified window size (\code{w}) from the current alarm,
it will be considered part of the current cluster. Otherwise, a new cluster will be formed.
}
\examples{
# Example usage:
alarms <- c(10, 15, 30, 35, 60)
change_points <- get_cps(alarms, w = 10)

}
