% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_functions.R
\name{ts_cor}
\alias{ts_cor}
\title{An Interactive Visualization of the ACF and PACF Functions}
\usage{
ts_cor(ts.obj, type = "both", seasonal = TRUE, ci = 0.95,
  lag.max = NULL, seasonal_lags = NULL)
}
\arguments{
\item{ts.obj}{A univariate time series object class 'ts'}

\item{type}{A character, defines the plot type - 'acf' for ACF plot, 'pacf' for PACF plot, and 'both' (default) for both ACF and PACF plots}

\item{seasonal}{A boolean, when set to TRUE (default) will color the seasonal lags}

\item{ci}{The significant level of the estimation - a numeric value between 0 and 1, default is set for 0.95}

\item{lag.max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m) 
where N is the number of observations and m the number of series. 
Will be automatically limited to one less than the number of observations in the series}

\item{seasonal_lags}{A vector of integers, highlight specific cyclic lags (besides the main seasonal lags of the series).
This is useful when working with multiseasonal time series data. For example, for a monthly series 
(e.g., frequency 12) setting the argument to 3 will highlight the quarterly lags}
}
\description{
An Interactive Visualization of the ACF and PACF Functions
}
\examples{

data(USgas)

ts_cor(ts.obj = USgas)

# Setting the maximum number of lags to 72
ts_cor(ts.obj = USgas, lag.max = 72)

# Plotting only ACF 
ts_cor(ts.obj = USgas, lag.max = 72, type = "acf")
}
