% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-processing.R
\name{calc_phase_pairs}
\alias{calc_phase_pairs}
\title{Calculate phase pair numbers}
\usage{
calc_phase_pairs(x)
}
\arguments{
\item{x}{vector of phase/condition labels.}
}
\value{
A vector containing an integer phase number for every observation.
}
\description{
Calculates a vector containing a unique phase number for every
  sequential occurrence of a phase or treatment condition. This is useful for 
  creating a grouping variable to be used in calculating effect sizes for each 
  pair of A-B phases within treatment reversal designs.
}
\examples{
x <- rep(c("A","B","C","B","C","A","C"), c(4:10))
calc_phase_pairs(x)

library(dplyr)
Schmidt2007 \%>\% 
  group_by(Behavior_type, Case_pseudonym) \%>\%
  mutate(phase_pair = calc_phase_pairs(Condition))

}
