% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_vars.R
\name{error_vars}
\alias{error_vars}
\title{Generate Variables for Error Loop}
\usage{
error_vars(marginal, support, method, means, vars, constants, lam, size, prob,
  mu, Sigma, rho_calc, q, r, k_cat, k_cont, k_pois, k_nb, Y_cat, Y, Yb, Y_pois,
  Y_nb, n, seed)
}
\arguments{
\item{marginal}{a list of length equal \code{k_cat}; the i-th element is a vector of the cumulative
probabilities defining the marginal distribution of the i-th variable;
if the variable can take r values, the vector will contain r - 1 probabilities (the r-th is assumed to be 1)}

\item{support}{a list of length equal \code{k_cat}; the i-th element is a vector of containing the r
ordered support values; if not provided, the default is for the i-th element to be the vector 1, ..., r}

\item{method}{the method used to generate the continuous variables.  "Fleishman" uses a third-order polynomial transformation
and "Polynomial" uses Headrick's fifth-order transformation.}

\item{means}{a vector of means for the continuous variables}

\item{vars}{a vector of variances}

\item{constants}{a matrix with \code{k_cont} rows, each a vector of constants c0, c1, c2, c3 (if \code{method} = "Fleishman") or
c0, c1, c2, c3, c4, c5 (if \code{method} = "Polynomial"), like that returned by
\code{\link[SimMultiCorrData]{find_constants}}}

\item{lam}{a vector of lambda (> 0) constants for the Poisson variables (see \code{\link[stats]{dpois}})}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{dnbinom}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture)}

\item{Sigma}{the 2 x 2 intermediate correlation matrix generated by \code{\link[SimMultiCorrData]{error_loop}}}

\item{rho_calc}{the 2 x 2 final correlation matrix calculated in \code{\link[SimMultiCorrData]{error_loop}}}

\item{q}{the row index of the 1st variable}

\item{r}{the column index of the 2nd variable}

\item{k_cat}{the number of ordinal (r >= 2 categories) variables}

\item{k_cont}{the number of continuous variables}

\item{k_pois}{the number of Poisson variables}

\item{k_nb}{the number of Negative Binomial variables}

\item{Y_cat}{the ordinal variables generated from \code{\link[SimMultiCorrData]{error_loop}}}

\item{Y}{the continuous (mean 0, variance 1) variables}

\item{Yb}{the continuous variables with desired mean and variance}

\item{Y_pois}{the Poisson variables}

\item{Y_nb}{the Negative Binomial variables}

\item{n}{the sample size}

\item{seed}{the seed value for random number generation}
}
\value{
A list with the following components:

\code{Sigma} the intermediate MVN correlation matrix

\code{rho_calc} the calculated final correlation matrix generated from Sigma

\code{Y_cat} the ordinal variables

\code{Y} the continuous (mean 0, variance 1) variables

\code{Yb} the continuous variables with desired mean and variance

\code{Y_pois} the Poisson variables

\code{Y_nb} the Negative Binomial variables
}
\description{
This function simulates the continuous, ordinal (r >= 2 categories), Poisson, or Negative Binomial variables
    used in \code{\link[SimMultiCorrData]{error_loop}}.  It is called in each iteration, regenerates all variables, and calculates the
    resulting correlation matrix.
    This function would not ordinarily be called directly by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{error_loop}}.
}
\seealso{
\code{\link[GenOrd]{ordcont}}, \code{\link[SimMultiCorrData]{rcorrvar}}, \code{\link[SimMultiCorrData]{rcorrvar2}},
    \code{\link[SimMultiCorrData]{error_loop}}
}
\keyword{correlation}
\keyword{error,}
