% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleCoveragePlot}
\alias{SingleCoveragePlot}
\alias{CoveragePlot}
\title{Plot Tn5 insertion sites over a region}
\usage{
SingleCoveragePlot(
  object,
  region,
  annotation = NULL,
  peaks = NULL,
  assay = NULL,
  fragment.path = NULL,
  group.by = NULL,
  window = 100,
  downsample = 0.1,
  height.tracks = 10,
  extend.upstream = 0,
  extend.downstream = 0,
  ymax = NULL,
  scale.factor = NULL,
  cells = NULL,
  idents = NULL,
  sep = c("-", "-")
)

CoveragePlot(
  object,
  region,
  annotation = NULL,
  peaks = NULL,
  assay = NULL,
  fragment.path = NULL,
  group.by = NULL,
  window = 100,
  downsample = 0.1,
  height.tracks = 10,
  extend.upstream = 0,
  extend.downstream = 0,
  scale.factor = NULL,
  ymax = NULL,
  cells = NULL,
  idents = NULL,
  sep = c("-", "-"),
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{region}{A set of genomic coordinates to show. Can be a GRanges object,
a string, or a vector of strings describing the genomic
coordinates to plot.}

\item{annotation}{An Ensembl based annotation package}

\item{peaks}{A GRanges object containing peak coordinates}

\item{assay}{Name of the  assay to plot}

\item{fragment.path}{Path to an index fragment file. If NULL, will look for a
path stored for the requested assay using the \code{\link{SetFragments}}
function}

\item{group.by}{Name of one or more metadata columns to group (color) the
cells by. Default is the current cell identities}

\item{window}{Smoothing window size}

\item{downsample}{Fraction of positions to retain in the plot.}

\item{height.tracks}{Height of the accessibility tracks relative to the
height of the gene annotation track.}

\item{extend.upstream}{Number of bases to extend the region upstream.}

\item{extend.downstream}{Number of bases to extend the region downstream.}

\item{ymax}{Maximum value for Y axis. If NULL (default) set to the highest
value among all the tracks.}

\item{scale.factor}{Scaling factor for track height. If NULL (default),
use the median group scaling factor determined by total number of fragments
sequences in each group.}

\item{cells}{Which cells to plot. Default all cells}

\item{idents}{Which identities to include in the plot. Default is all
identities.}

\item{sep}{Separators to use for strings encoding genomic coordinates. First
element is used to separate the chromosome from the coordinates, second
element is used to separate the start from end coordinate.}

\item{...}{Additional arguments passed to \code{\link[patchwork]{wrap_plots}}}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot fragment coverage (frequence of Tn5 insertion) within given regions
for groups of cells.
}
\details{
Thanks to Andrew Hill for providing an early version of this function
\url{http://andrewjohnhill.com/blog/2019/04/12/streamlining-scatac-seq-visualization-and-analysis/}
}
\examples{
\donttest{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
atac_small <- SetFragments(atac_small, file = fpath)
CoveragePlot(object = atac_small, region = c("chr1-713500-714500"))
}
}
