% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_bbox.R
\name{update_bbox}
\alias{update_bbox}
\title{Update bounding box of sf object}
\usage{
update_bbox(sfobj)
}
\arguments{
\item{sfobj}{Layer to be updated. \code{sf} object.}
}
\value{
\code{sf} object, with corrected bounds.
}
\description{
Function to update the coordinates of the bounding box of sf vector data objects (e.g. after cropping or subsetting).
}
\examples{
# Update bbox for subset of sf object
\dontrun{
data(clea_deu2009)
out_1 <- update_bbox(clea_deu2009[clea_deu2009$cst_n\%in\%c("Berlin"),])
out_1

# Bounding box of full dataset
data.table::as.data.table(clea_deu2009)[,sf::st_bbox(geometry)]

# Bounding box of subset (incorrect)
data.table::as.data.table(clea_deu2009)[cst_n\%in\%c("Berlin"),sf::st_bbox(geometry)]

# Corrected bounding box
data.table::as.data.table(out_1)[,sf::st_bbox(geometry)]
}
}
