% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line2poly.R
\name{line2poly}
\alias{line2poly}
\title{Line-in-polygon analysis}
\usage{
line2poly(
  linez,
  polyz,
  poly_id,
  measurez = c("length", "density", "distance"),
  outvar_name = "line",
  unitz = "km",
  reproject = TRUE,
  na_val = NA,
  verbose = TRUE
)
}
\arguments{
\item{linez}{Source polyline layer. \code{sf} object.}

\item{polyz}{Destination polygon layer. Must have identical CRS to \code{linez}. \code{sf} object.}

\item{poly_id}{Name of unique ID column for destination polygon layer. Character string.}

\item{measurez}{Desired measurements. Could be any of "length" (sum of line lengths by polygon), "density" (sum of line lengths divided by area of polygon) and/or "distance" (distance from each polygon to nearest line feature). Default is to report all three. Character string or vector of character strings.}

\item{outvar_name}{Name (root) to be given to output variable. Default is \code{"line"}. Character string.}

\item{unitz}{Units of measurement (linear). Defaul is \code{"km"}. Character string.}

\item{reproject}{Temporarily reproject layers to planar projection for geometric operations? Defaul is \code{TRUE}. Logical.}

\item{na_val}{Value to be assigned to missing values (line lengths and densities only). Defaul is \code{NA}. Logical or list.}

\item{verbose}{Print status messages and progress? Default is \code{TRUE}. Logical.}
}
\value{
An \code{sf} polygon object, with summary statisics of \code{linez} features aggregated to the geometries of \code{polyz}.

If \code{measurez = "lengths"}, contains fields with suffixes
\itemize{
 \item{"\code{_length}". }{Sum of line lengths within each polygon, in km or other units supplied in \code{unitz}.}
 }
If \code{measurez = "density"}, contains fields with suffixes
\itemize{
 \item{"\code{_length}". }{Sum of line lengths within each polygon, in km or other units supplied in \code{unitz}.}
 \item{"\code{_area}". }{Area of each polygon, in km^2 or the square of linear units supplied in \code{unitz}.}
 \item{"\code{_density}". }{Sum of line lengths divided by area of each polygon, in km/km^2 or other units supplied in \code{unitz}.}
 }
If \code{measurez = "distance"}, contains fields with suffixes
\itemize{
 \item{"\code{_distance}". }{Distance from each polygon to nearest line feature, in km or other units supplied in \code{unitz}.}
 }
If \code{measurez = c("length","density","distance")} (default), contains all of the above.
}
\description{
Function for basic geometry calculations on polyline features, within an overlapping destination polygon layer.
}
\examples{
# Road lengths, densities and distance from polygon to nearest highway
\dontrun{
data(hex_05_deu)
data(highways_deu1992)
out_1 <- line2poly(linez = highways_deu1992,
                   polyz = hex_05_deu,
                   poly_id = "HEX_ID")
plot(out_1["line_length"])
plot(out_1["line_density"])
plot(out_1["line_distance"])
}

# Replace missing road lengths and densities with 0's, rename variables
\dontrun{
out_2 <- line2poly(linez = highways_deu1992,
                   polyz = hex_05_deu,
                   poly_id = "HEX_ID",
                   outvar_name = "road",
                   na_val = 0)
plot(out_2["road_length"])
plot(out_2["road_density"])
plot(out_2["road_distance"])
}
}
