% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimDE.R
\name{optimDE}
\alias{optimDE}
\title{Minimization by Differential Evolution}
\usage{
optimDE(x = NULL, fun, lower, upper, control = list(), ...)
}
\arguments{
\item{x}{optional start point, not used in DEoptim}

\item{fun}{objective function, which receives a matrix x and returns observations y}

\item{lower}{boundary of the search space}

\item{upper}{boundary of the search space}

\item{control}{list of control parameters
\describe{
  \item{\code{funEvals}}{Budget, number of function evaluations allowed. Default is 200.}
  \item{\code{populationSize}}{Population size or number of particles in the population. Default is 10*dimension.}
}}

\item{...}{passed to \code{fun}}
}
\value{
list, with elements
\describe{
  \item{\code{x}}{archive of the best member at each iteration}
  \item{\code{y}}{archive of the best value of fn at each iteration}
  \item{\code{xbest}}{best solution}
  \item{\code{ybest}}{best observation}
  \item{\code{count}}{number of evaluations of \code{fun}}
}
}
\description{
For minimization, this function uses the \code{"DEoptim"} method from the
code{DEoptim} package. It is basically a wrapper, to enable DEoptim for usage
in SPOT.
}
\examples{
res <- optimDE(,lower = c(-10,-20),upper=c(20,8),fun = funSphere)
res$ybest
}
