% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPQ.R
\name{EPQ}
\alias{EPQ}
\title{Economic Production Quantity model}
\usage{
EPQ(d, p, k, h, b = 0)
}
\arguments{
\item{d}{Deterministic demant per time unit}

\item{p}{Production rate}

\item{k}{Ordering or fixed cost per order.}

\item{h}{Holding cost per unit of product.}

\item{b}{Shortage penalty cost per unit (default:0).}
}
\value{
\code{EPQ()} returns a list containing:
\item{Q}{Order quantity}
\item{t}{Time required to produce the batch quantity}
\item{T}{Time between orders (cycle length or time)}
\item{I}{Maximum inventory level}
\item{TC}{Total cost}
}
\description{
Implements the Economic Production Quantity (EPQ) model.
}
\details{
The EPQ model is an extension of the \code{\link{EOQ}} model. It considers
finite production rate, that is, the inventory is replenished
gradually as the order is produced. Note that this assumption
requires the production rate to be greater than the demand rate (p>d)
otherwise there would be no inventory at any time.

The model considers that a new order is produced incrementally when the
inventory reaches zero. During the time that production run,
\eqn{t=Q/p}{t=Q/p}, inventory is accumulated at rate \eqn{p-d}{p-d}, which
implies that when the production of the batch Q is finished the
inventory will reach its maximum level I.
}
\examples{
 \dontrun{
#Suppose k = 100, h = 5, d = 200, p = 1000. Then the production run at
#t=0.1, the optimal order interval is T = 0.5, the optimal order quantity
#is Q = 100, the maximum inventory level is I=80 and the total cost is
#TC = $400.}
 
EPQ(d=200,p=1000,k=100,h=5)

}
\references{
- Gallego, G. "IEOR4000: Production Management" (Lecture 2), Columbia (2004).
}
\seealso{
EOQ, newsboy, WW
}
\keyword{Lot}
\keyword{models}
\keyword{sizing}
