% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss_plot.R
\name{plot}
\alias{plot}
\alias{plot.wtss}
\title{Generic interface for ploting time series}
\usage{
\method{plot}{wtss}(x, y, ..., colors = "Dark2")
}
\arguments{
\item{x}{object of class "wtss"}

\item{y}{ignored}

\item{...}{further specifications for \link{plot}.}

\item{colors}{Color pallete to be used (based on Color Brewer - 
default is "Dark2").}
}
\value{
Input  tibble (useful for chaining functions).
}
\description{
Given a tibble with a set of time series, plot them.
}
\examples{
\donttest{
# Access to external service
# Read one time series from the WTSS server
# plot one time series
wtss_server <- "http://www.esensing.dpi.inpe.br/wtss"
ts   <- Rwtss::time_series(wtss_server, name = "MOD13Q1", 
                attributes = c("ndvi","evi"), 
                longitude = -45.00, latitude  = -12.00,
                start_date = "2000-02-18", end_date = "2016-12-18")
plot(ts)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
