% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BYlogreg.R
\name{logregBY}
\alias{logregBY}
\alias{BYlogreg}
\title{Bianco and Yohai estimator for logistic regression}
\usage{
logregBY(x0, y, intercept = 1, const = 0.5, kmax = 1000, maxhalf = 10)
}
\arguments{
\item{x0}{matrix of explanatory variables;}

\item{y}{vector of binomial responses (0 or 1);}

\item{intercept}{1 or 0 indicating if an intercept is included or or not}

\item{const}{tuning constant used in the computation of the estimator (default=0.5);}

\item{kmax}{maximum number of iterations before convergence (default=1000);}

\item{maxhalf}{max number of step-halving (default=10).}
}
\value{
A list with the following components:
\item{coefficients}{estimates for the regression coefficients}
\item{standard.deviation}{standard deviations of the coefficients}
\item{fitted.values}{fitted values}
\item{residual.deviances}{residual deviances}
\item{components}{logical value indicating whether convergence was achieved}
\item{objective}{value of the objective function at the minimum}
}
\description{
This function computes the M-estimator proposed by Bianco and Yohai for
logistic regression. By default, an intercept term is included and p
parameters are estimated. Modified by Yohai (2018) to take as initial estimator
a weighted ML estimator with weights derived from the MCD estimator.
For more details we refer to Croux, C., and Haesbroeck, G. (2002),
"Implementing the Bianco and Yohai estimator for Logistic Regression"
}
\examples{
data(skin)
Xskin <- as.matrix( skin[, 1:2] )
yskin <- skin$vasoconst
skinBY <- logregBY(Xskin, yskin, intercept=1)
skinBY$coeff
skinBY$standard.deviation

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Christophe Croux, Gentiane Haesbroeck, Victor Yohai
}
