\name{posterior.step1}
\alias{posterior.step1}
\title{Posterior Distribution}
\description{
Samples from the posterior distribution of the data by means of blavaan.
These samples form the basis for the predictive distribution in the prior predictive check.}
\usage{
posterior.step1(y.o, model,
    sample.cov = NULL, sample.mean = NULL, sample.nobs = NULL,
    group = NULL, constraints = "", WLS.V = NULL, NACOV = NULL,
    nchains=2, nadapt, nburnin, nsample, dp = NULL, convergence = "manual",target,
    imp=imp)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y.o}{A data frame containing the original data for the replication test.}
  \item{model}{The (b)lavaan model that is to be fitted to the data.}
  \item{sample.cov}{Numeric matrix. A sample variance-covariance matrix. The rownames and/or colnames must contain the observed variable names. For a multiple group analysis, a list with a variance-covariance matrix for each group. Note that if maximum likelihood estimation is used and likelihood="normal", the user provided covariance matrix is internally rescaled by multiplying it with a factor (N-1)/N, to ensure that the covariance matrix has been divided by N. This can be turned off by setting the sample.cov.rescale argument to FALSE.
}
  \item{sample.mean}{A sample mean vector. For a multiple group analysis, a list with a mean vector for each group.}
  \item{sample.nobs}{
Number of observations if the full data frame is missing and only sample moments are given. For a multiple group analysis, a list or a vector with the number of observations for each group.}
  \item{group}{
A variable name in the data frame defining the groups in a multiple group analysis.}
  \item{constraints}{
Additional (in)equality constraints not yet included in the model syntax. See model.syntax for more information. Note that the replication hypothesis should not be specified here!}
  \item{WLS.V}{
A user provided weight matrix to be used by estimator "WLS"; if the estimator is "DWLS", only the diagonal of this matrix will be used. For a multiple group analysis, a list with a weight matrix for each group. The elements of the weight matrix should be in the following order (if all data is continuous): first the means (if a meanstructure is involved), then the lower triangular elements of the covariance matrix including the diagonal, ordered column by column. In the categorical case: first the thresholds (including the means for continuous variables), then the slopes (if any), the variances of continuous variables (if any), and finally the lower triangular elements of the correlation/covariance matrix excluding the diagonal, ordered column by column.}
  \item{NACOV}{
A user provided matrix containing the elements of (N times) the asymptotic variance-covariance matrix of the sample statistics. For a multiple group analysis, a list with an asymptotic variance-covariance matrix for each group. See the WLS.V argument for information about the order of the elements.}
  \item{nchains}{A scalar indicating the number of chains to be used in the Bayesian analysis. Default value = 2.}
  \item{nadapt}{The number of blavaan adaptive iterations to use at the start of the simulation. Default value = 1,000}
  \item{nburnin}{A scalar indicating the number of burnin iterations to be used in the Bayesian analysis.}
  \item{nsample}{A scalar indicating the number of samples to be taken from the posterior after burnin.}
  \item{convergence}{Default = "manual". If "auto", parameters will be sampled until convergence is achieved (via autorun.jags). In this case, the arguments burnin and sample are passed to autorun.jags as startburnin and startsample, respectively. Otherwise, parameters are sampled as specified by the user (or by the run.jags defaults).}
  \item{target}{Desired MCMC package ("jags" is default, but "stan" also available).}
\item{dp}{blavaan default prior distributions on different types of parameters, typically the result of a call to dpriors(). See the dpriors() help file for more information.}
  \item{imp}{A multiply imputed dataset stored in an object of class mids as generated by mice. If there is no imputed data, specify imp = NULL.}}

\value{
\item{post}{A matrix with samples from the posterior.}
\item{pT}{A data.frame containing the parameter table for the fitted model as given by parTable {lavaan}}
\item{free.i}{A vector with indices for the freely estimated parameters as given in pT.}
}

\seealso{\code{\link{blavaan}}, \code{\link{lavaan}}}

\keyword{htest }% use one of  RShowDoc("KEYWORDS")
\keyword{models }% __ONLY ONE__ keyword per line
