% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eia2tidy_all.R
\name{eia2tidy_all}
\alias{eia2tidy_all}
\title{EIA API multiple calls with tidy output}
\usage{
eia2tidy_all(
  tickers = tibble::tribble(~ticker, ~name, "PET.W_EPC0_SAX_YCUOK_MBBL.W",
    "CrudeCushing", "NG.NW2_EPG0_SWO_R48_BCF.W", "NGLower48"),
  key,
  long = TRUE
)
}
\arguments{
\item{tickers}{tribble of EIA series and names you want to assign. \code{character}}

\item{key}{Your private EIA API token as character "yourapikey". \code{character}}

\item{long}{TRUE (default) to return a long data frame or FASLE for wide. \code{logical}}
}
\value{
A tibble object with class date for weekly, monthly, quarterly or annual data and class POSIXct for hourly. \code{tibble}
}
\description{
Extracts data from the Energy Information Administration (EIA) API to tibble format with optional custom series name.
Makes a clean wrapper for use with purrr for multiple series extraction. Query Browser at https://www.eia.gov/opendata/qb.php.
}
\examples{
\dontrun{
eia2tidy_all(tickers = tibble::tribble(~ticker, ~name,
                         "PET.W_EPC0_SAX_YCUOK_MBBL.W", "CrudeCushing",
                         "NG.NW2_EPG0_SWO_R48_BCF.W", "NGLower48"),
            key = "your API key", long = TRUE)
}
}
\author{
Philippe Cote
}
