% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICLinearDiscriminantClassifier.R
\name{ICLinearDiscriminantClassifier}
\alias{ICLinearDiscriminantClassifier}
\title{Implicitly Constrained Semi-supervised Linear Discriminant Classifier}
\usage{
ICLinearDiscriminantClassifier(X, y, X_u, prior = NULL, scale = FALSE,
  init = NULL, sup_prior = FALSE, x_center = FALSE, ...)
}
\arguments{
\item{X}{design matrix of the labeled objects}

\item{y}{vector with labels}

\item{X_u}{design matrix of the labeled objects}

\item{prior}{set a fixed class prior}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{init}{not currently used}

\item{sup_prior}{logical; use the prior estimates based only on the labeled data, not the imputed labels (default: FALSE)}

\item{x_center}{logical; Whether the data should be centered}

\item{...}{Additional Parameters, Not used}
}
\description{
Semi-supervised version of Linear Discriminant Analysis using implicit constraints as described in (Krijthe & Loog 2014). This method finds the soft labeling of the unlabeled objects, whose resulting LDA solution gives the highest log-likelihood when evaluated on the labeled objects only. See also \code{\link{ICLeastSquaresClassifier}}.
}
\references{
Krijthe, J.H. & Loog, M., 2014. Implicitly Constrained Semi-Supervised Linear Discriminant Analysis. In International Conference on Pattern Recognition. Stockholm, pp. 3762-3767.
}
\seealso{
Other RSSL classifiers: \code{\link{EMLinearDiscriminantClassifier}},
  \code{\link{GRFClassifier}},
  \code{\link{ICLeastSquaresClassifier}},
  \code{\link{KernelLeastSquaresClassifier}},
  \code{\link{LaplacianKernelLeastSquaresClassifier}},
  \code{\link{LaplacianSVM}},
  \code{\link{LeastSquaresClassifier}},
  \code{\link{LinearDiscriminantClassifier}},
  \code{\link{LinearSVM}}, \code{\link{LinearTSVM}},
  \code{\link{LogisticLossClassifier}},
  \code{\link{LogisticRegression}},
  \code{\link{MCLinearDiscriminantClassifier}},
  \code{\link{MCNearestMeanClassifier}},
  \code{\link{MCPLDA}},
  \code{\link{MajorityClassClassifier}},
  \code{\link{NearestMeanClassifier}},
  \code{\link{QuadraticDiscriminantClassifier}},
  \code{\link{S4VM}}, \code{\link{SVM}},
  \code{\link{SelfLearning}}, \code{\link{TSVM}},
  \code{\link{USMLeastSquaresClassifier}},
  \code{\link{WellSVM}}, \code{\link{svmlin}}
}

