% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dropConstraint.R
\name{dropConstraint}
\alias{dropConstraint}
\title{Uniqueness Constraints}
\usage{
dropConstraint(graph, label = character(), key = character(), all = FALSE)
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character string.}

\item{key}{A character string.}

\item{all}{A logical constant. If \code{TRUE}, drop all constraints in the graph.}
}
\description{
Drop uniqueness constraint(s) for a given label and property key or for the entire graph database.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

addConstraint(graph, "Person", "name")
getConstraint(graph)

dropConstraint(graph, "Person", "name")
getConstraint(graph)
}
}
\seealso{
\code{\link{addConstraint}}, \code{\link{getConstraint}}
}

