/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JvmFinishedEvent;
import org.apache.hadoop.util.Shell;

class JvmManager {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JvmManager");
    private JvmManagerForType mapJvmManager;
    private JvmManagerForType reduceJvmManager;

    public JvmEnv constructJvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, Map<String, String> env, JobConf conf) {
        return new JvmEnv(setup, vargs, stdout, stderr, logSize, workDir, env, conf);
    }

    public JvmManager(TaskTracker tracker) {
        this.mapJvmManager = new JvmManagerForType(tracker.getMaxCurrentMapTasks(), true, tracker);
        this.reduceJvmManager = new JvmManagerForType(tracker.getMaxCurrentReduceTasks(), false, tracker);
    }

    JvmManagerForType getJvmManagerForType(TaskType type) {
        if (type.equals((Object)TaskType.MAP)) {
            return this.mapJvmManager;
        }
        if (type.equals((Object)TaskType.REDUCE)) {
            return this.reduceJvmManager;
        }
        return null;
    }

    void setPidToJvm(JVMId jvmId, String pid) {
        if (jvmId.isMapJVM()) {
            this.mapJvmManager.jvmIdToPid.put(jvmId, pid);
        } else {
            this.reduceJvmManager.jvmIdToPid.put(jvmId, pid);
        }
    }

    String getPid(TaskRunner t) {
        if (t != null && t.getTask() != null) {
            if (t.getTask().isMapTask()) {
                JVMId id = this.mapJvmManager.runningTaskToJvm.get(t);
                if (id != null) {
                    return this.mapJvmManager.jvmIdToPid.get(id);
                }
            } else {
                JVMId id = this.reduceJvmManager.runningTaskToJvm.get(t);
                if (id != null) {
                    return this.reduceJvmManager.jvmIdToPid.get(id);
                }
            }
        }
        return null;
    }

    public void stop() {
        this.mapJvmManager.stop();
        this.reduceJvmManager.stop();
    }

    public boolean isJvmKnown(JVMId jvmId) {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.isJvmknown(jvmId);
        }
        return this.reduceJvmManager.isJvmknown(jvmId);
    }

    public void launchJvm(TaskRunner t, JvmEnv env) {
        if (t.getTask().isMapTask()) {
            this.mapJvmManager.reapJvm(t, env);
        } else {
            this.reduceJvmManager.reapJvm(t, env);
        }
    }

    public TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) throws IOException {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.getTaskForJvm(jvmId);
        }
        return this.reduceJvmManager.getTaskForJvm(jvmId);
    }

    public void taskFinished(TaskRunner tr) {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskFinished(tr);
        } else {
            this.reduceJvmManager.taskFinished(tr);
        }
    }

    public void taskKilled(TaskRunner tr) {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskKilled(tr);
        } else {
            this.reduceJvmManager.taskKilled(tr);
        }
    }

    public void killJvm(JVMId jvmId) {
        if (jvmId.isMap) {
            this.mapJvmManager.killJvm(jvmId);
        } else {
            this.reduceJvmManager.killJvm(jvmId);
        }
    }

    static void deleteWorkDir(TaskTracker tracker, Task task) throws IOException {
        tracker.getCleanupThread().addToQueue(TaskTracker.buildTaskControllerTaskPathDeletionContexts(tracker.getLocalFileSystem(), tracker.getLocalFiles(tracker.getJobConf(), ""), task, true, tracker.getTaskController()));
    }

    static class JvmEnv {
        List<String> vargs;
        List<String> setup;
        File stdout;
        File stderr;
        File workDir;
        long logSize;
        JobConf conf;
        Map<String, String> env;

        public JvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, Map<String, String> env, JobConf conf) {
            this.setup = setup;
            this.vargs = vargs;
            this.stdout = stdout;
            this.stderr = stderr;
            this.workDir = workDir;
            this.env = env;
            this.conf = conf;
        }
    }

    static class JvmManagerForType {
        Map<JVMId, TaskRunner> jvmToRunningTask = new HashMap<JVMId, TaskRunner>();
        Map<TaskRunner, JVMId> runningTaskToJvm = new HashMap<TaskRunner, JVMId>();
        Map<JVMId, JvmRunner> jvmIdToRunner = new HashMap<JVMId, JvmRunner>();
        Map<JVMId, String> jvmIdToPid = new HashMap<JVMId, String>();
        int maxJvms;
        boolean isMap;
        Random rand = new Random(System.currentTimeMillis());
        private TaskTracker tracker;

        public JvmManagerForType(int maxJvms, boolean isMap, TaskTracker tracker) {
            this.maxJvms = maxJvms;
            this.isMap = isMap;
            this.tracker = tracker;
        }

        public synchronized void setRunningTaskForJvm(JVMId jvmId, TaskRunner t) {
            this.jvmToRunningTask.put(jvmId, t);
            this.runningTaskToJvm.put(t, jvmId);
            this.jvmIdToRunner.get(jvmId).setBusy(true);
        }

        public synchronized TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) throws IOException {
            if (this.jvmToRunningTask.containsKey(jvmId)) {
                TaskRunner taskRunner = this.jvmToRunningTask.get(jvmId);
                JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
                Task task = taskRunner.getTaskInProgress().getTask();
                TaskController.TaskControllerContext context = new TaskController.TaskControllerContext();
                context.env = jvmRunner.env;
                context.task = task;
                if (!jvmRunner.env.conf.get("mapred.task.id").equals(task.getTaskID().toString())) {
                    try {
                        this.tracker.getTaskController().initializeTask(context);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to initialize the new task " + task.getTaskID().toString() + " to be given to JVM with id " + jvmId));
                        throw e;
                    }
                }
                jvmRunner.taskGiven(task);
                return taskRunner.getTaskInProgress();
            }
            return null;
        }

        public synchronized boolean isJvmknown(JVMId jvmId) {
            return this.jvmIdToRunner.containsKey(jvmId);
        }

        public synchronized void taskFinished(TaskRunner tr) {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
                if (jvmRunner != null) {
                    jvmRunner.taskRan();
                }
            }
        }

        public synchronized void taskKilled(TaskRunner tr) {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                this.killJvm(jvmId);
            }
        }

        public synchronized void killJvm(JVMId jvmId) {
            JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
            if (jvmRunner != null) {
                this.killJvmRunner(jvmRunner);
            }
        }

        public synchronized void stop() {
            ArrayList<JvmRunner> list = new ArrayList<JvmRunner>();
            list.addAll(this.jvmIdToRunner.values());
            for (JvmRunner jvm : list) {
                this.killJvmRunner(jvm);
            }
        }

        private synchronized void killJvmRunner(JvmRunner jvmRunner) {
            jvmRunner.kill();
            this.removeJvm(jvmRunner.jvmId);
        }

        private synchronized void removeJvm(JVMId jvmId) {
            this.jvmIdToRunner.remove(jvmId);
            this.jvmIdToPid.remove(jvmId);
        }

        private synchronized void reapJvm(TaskRunner t, JvmEnv env) {
            if (t.getTaskInProgress().wasKilled()) {
                return;
            }
            boolean spawnNewJvm = false;
            JobID jobId = t.getTask().getJobID();
            int numJvmsSpawned = this.jvmIdToRunner.size();
            JvmRunner runnerToKill = null;
            if (numJvmsSpawned >= this.maxJvms) {
                Iterator<Map.Entry<JVMId, JvmRunner>> jvmIter = this.jvmIdToRunner.entrySet().iterator();
                while (jvmIter.hasNext()) {
                    JvmRunner jvmRunner = jvmIter.next().getValue();
                    JobID jId = jvmRunner.jvmId.getJobId();
                    if (jId.equals(jobId) && !jvmRunner.isBusy() && !jvmRunner.ranAll()) {
                        this.setRunningTaskForJvm(jvmRunner.jvmId, t);
                        LOG.info((Object)("No new JVM spawned for jobId/taskid: " + jobId + "/" + t.getTask().getTaskID() + ". Attempting to reuse: " + jvmRunner.jvmId));
                        return;
                    }
                    if ((!jId.equals(jobId) || !jvmRunner.ranAll()) && (jId.equals(jobId) || jvmRunner.isBusy())) continue;
                    runnerToKill = jvmRunner;
                    spawnNewJvm = true;
                }
            } else {
                spawnNewJvm = true;
            }
            if (spawnNewJvm) {
                if (runnerToKill != null) {
                    LOG.info((Object)("Killing JVM: " + runnerToKill.jvmId));
                    this.killJvmRunner(runnerToKill);
                }
                this.spawnNewJvm(jobId, env, t);
                return;
            }
            throw new RuntimeException("Inconsistent state!!! JVM Manager reached an unstable state while reaping a JVM for task: " + t.getTask().getTaskID() + " " + this.getDetails());
        }

        private String getDetails() {
            StringBuffer details = new StringBuffer();
            details.append("Number of active JVMs:").append(this.jvmIdToRunner.size());
            for (JVMId jvmId : this.jvmIdToRunner.keySet()) {
                details.append("\n  JVMId ").append(jvmId.toString()).append(" #Tasks ran: ").append(this.jvmIdToRunner.get((Object)jvmId).numTasksRan).append(" Currently busy? ").append(this.jvmIdToRunner.get((Object)jvmId).busy).append(" Currently running: ").append(this.jvmToRunningTask.get(jvmId).getTask().getTaskID().toString());
            }
            return details.toString();
        }

        private void spawnNewJvm(JobID jobId, JvmEnv env, TaskRunner t) {
            JvmRunner jvmRunner = new JvmRunner(env, jobId);
            this.jvmIdToRunner.put(jvmRunner.jvmId, jvmRunner);
            jvmRunner.setDaemon(true);
            jvmRunner.setName("JVM Runner " + jvmRunner.jvmId + " spawned.");
            this.setRunningTaskForJvm(jvmRunner.jvmId, t);
            LOG.info((Object)jvmRunner.getName());
            jvmRunner.start();
        }

        private synchronized void updateOnJvmExit(JVMId jvmId, int exitCode) {
            this.removeJvm(jvmId);
            TaskRunner t = this.jvmToRunningTask.remove(jvmId);
            if (t != null) {
                this.runningTaskToJvm.remove(t);
                if (exitCode != 0) {
                    t.setExitCode(exitCode);
                }
                t.signalDone();
            }
        }

        class JvmRunner
        extends Thread {
            JvmEnv env;
            volatile boolean killed = false;
            volatile int numTasksRan;
            final int numTasksToRun;
            JVMId jvmId;
            volatile boolean busy = true;
            private Shell.ShellCommandExecutor shexec;
            private TaskController.TaskControllerContext initalContext;
            private List<Task> tasksGiven = new ArrayList<Task>();

            void taskGiven(Task task) {
                this.tasksGiven.add(task);
            }

            public JvmRunner(JvmEnv env, JobID jobId) {
                this.env = env;
                this.jvmId = new JVMId(jobId, JvmManagerForType.this.isMap, JvmManagerForType.this.rand.nextInt());
                this.numTasksToRun = env.conf.getNumTasksToExecutePerJvm();
                LOG.info((Object)("In JvmRunner constructed JVM ID: " + this.jvmId));
            }

            @Override
            public void run() {
                this.runChild(this.env);
                this.jvmFinished();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runChild(JvmEnv env) {
                this.initalContext = new TaskController.TaskControllerContext();
                try {
                    env.vargs.add(Integer.toString(this.jvmId.getId()));
                    this.initalContext.task = JvmManagerForType.this.jvmToRunningTask.get(this.jvmId).getTask();
                    this.initalContext.env = env;
                    JvmManagerForType.this.tracker.getTaskController().launchTaskJVM(this.initalContext);
                }
                catch (IOException ioe) {
                }
                finally {
                    this.shexec = this.initalContext.shExec;
                    if (this.shexec == null) {
                        return;
                    }
                    this.kill();
                    int exitCode = this.shexec.getExitCode();
                    JvmManagerForType.this.updateOnJvmExit(this.jvmId, exitCode);
                    LOG.info((Object)("JVM : " + this.jvmId + " exited with exit code " + exitCode + ". Number of tasks it ran: " + this.numTasksRan));
                    try {
                        if (env.conf.getNumTasksToExecutePerJvm() != 1) {
                            JvmManager.deleteWorkDir(JvmManagerForType.this.tracker, this.initalContext.task);
                        }
                    }
                    catch (IOException ie) {}
                }
            }

            synchronized void kill() {
                if (!this.killed) {
                    TaskController controller = JvmManagerForType.this.tracker.getTaskController();
                    if (this.initalContext != null && this.initalContext.env != null) {
                        this.initalContext.pid = JvmManagerForType.this.jvmIdToPid.get(this.jvmId);
                        this.initalContext.sleeptimeBeforeSigkill = JvmManagerForType.this.tracker.getJobConf().getLong("mapred.tasktracker.tasks.sleeptime-before-sigkill", 5000L);
                        controller.destroyTaskJVM(this.initalContext);
                    } else {
                        LOG.info((Object)String.format("JVM Not killed %s but just removed", this.jvmId.toString()));
                    }
                    this.killed = true;
                }
            }

            private void jvmFinished() {
                Task firstTask = this.initalContext.task;
                JvmFinishedEvent jfe = new JvmFinishedEvent(new JVMInfo(TaskLog.getAttemptDir(firstTask.getTaskID(), firstTask.isTaskCleanupTask()), this.tasksGiven));
                JvmManagerForType.this.tracker.getUserLogManager().addLogEvent(jfe);
            }

            public void taskRan() {
                this.busy = false;
                ++this.numTasksRan;
            }

            public boolean ranAll() {
                return this.numTasksRan == this.numTasksToRun;
            }

            public void setBusy(boolean busy) {
                this.busy = busy;
            }

            public boolean isBusy() {
                return this.busy;
            }
        }
    }
}

