/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.decoder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.Message;
import org.openfast.MessageBlockReader;
import org.openfast.examples.Assert;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.decoder.FastMessageDecoder;

public class Main
extends OpenFastExample {
    private static final String BLOCK = "block";
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("d", "data", true, "FAST encoded data file");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("n", "ns", false, "Enables namespace awareness");
        options.addOption("t", "template", true, "Message template definition file");
        options.addOption("v", "trace", false, "Trace");
        options.addOption("j", "readOffset", true, "The number of leading bytes that should be discarded when reading each message.");
        options.addOption("b", BLOCK, false, "Reads an initial block size from the stream");
    }

    public static void main(String[] args) {
        CommandLine cl = Main.parseCommandLine("consumer", args, options);
        if (cl.hasOption("help")) {
            Main.displayHelp("consumer", options);
        }
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        File dataFile = null;
        try {
            dataFile = Main.getFile(cl, "data");
            Assert.assertTrue(dataFile.exists(), "The fast data file \"" + dataFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!dataFile.isDirectory(), "The fast data file \"" + dataFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(dataFile.canRead(), "The fast data file \"" + dataFile.getAbsolutePath() + "\" is not readable.");
            templatesFile = Main.getFile(cl, "template");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Main.displayHelp("consumer", options);
        }
        int readOffset = cl.hasOption("readOffset") ? Main.getInteger(cl, "readOffset") : 0;
        FastMessageDecoder consumer = new FastMessageDecoder(dataFile, templatesFile, cl.hasOption("ns"), readOffset);
        if (cl.hasOption(BLOCK)) {
            consumer.setBlockReader(new MessageBlockReader(){
                byte[] buffer = new byte[4];

                public boolean readBlock(InputStream in) {
                    try {
                        int numRead = in.read(this.buffer);
                        return numRead >= this.buffer.length;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }

                public void messageRead(InputStream in, Message message) {
                }
            });
        }
        if (cl.hasOption("trace")) {
            consumer.setTraceEnabled();
        }
        try {
            consumer.start();
        }
        catch (IOException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
            System.exit(1);
        }
    }
}

