/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.Message;
import org.openfast.MessageBlockReader;
import org.openfast.examples.OpenFastExample;
import org.openfast.impl.CmeMessageBlockReader;
import org.openfast.impl.CmeTcpReplayMessageBlockReader;

public class MessageBlockReaderFactory {
    final OpenFastExample.Variant variant;
    final int offset;
    final boolean isMulticast;

    public MessageBlockReaderFactory() {
        this(OpenFastExample.Variant.DEFAULT, 0, true);
    }

    public MessageBlockReaderFactory(OpenFastExample.Variant variant, int offset, boolean isMulticast) {
        this.variant = variant;
        this.offset = offset;
        this.isMulticast = isMulticast;
    }

    public MessageBlockReader create() {
        if (OpenFastExample.Variant.CME == this.variant) {
            if (this.isMulticast) {
                return new CmeMessageBlockReader();
            }
            return new CmeTcpReplayMessageBlockReader();
        }
        return this.createDefault();
    }

    MessageBlockReader createDefault() {
        if (this.offset <= 0) {
            return MessageBlockReader.NULL;
        }
        return new MessageBlockReader(){

            public void messageRead(InputStream in, Message message) {
            }

            public boolean readBlock(InputStream in) {
                try {
                    in.skip(MessageBlockReaderFactory.this.offset);
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public String toString() {
                return "(default block reader, offset=" + MessageBlockReaderFactory.this.offset + ")";
            }
        };
    }
}

