% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recalibration.R
\name{recalibratePlpRefit}
\alias{recalibratePlpRefit}
\title{recalibratePlpRefit}
\usage{
recalibratePlpRefit(plpModel, newPopulation, newData, returnModel = FALSE)
}
\arguments{
\item{plpModel}{The trained plpModel (runPlp$model)}

\item{newPopulation}{The population created using createStudyPopulation() who will have their risks predicted}

\item{newData}{An object of type \code{plpData} - the patient level prediction
data extracted from the CDM.}

\item{returnModel}{Logical: return the refitted model}
}
\value{
An prediction dataframe with the predictions of the recalibrated model added
}
\description{
Recalibrating a model by refitting it
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000)
saveLoc <- file.path(tempdir(), "recalibratePlpRefit")
plpResults <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
newData <- simulatePlpData(simulationProfile, n = 1000)
newPopulation <- createStudyPopulation(newData, outcomeId = 3)
predictions <- recalibratePlpRefit(plpModel = plpResults$model, 
                                   newPopulation = newPopulation, 
                                   newData = newData)
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
