% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_packages.R
\name{get_packages}
\alias{get_packages}
\title{Get information about the package used in the project}
\usage{
get_packages(project_path = ".", include_pattern = "\\\\.R(md)?$",
  exclude_pattern = "tests/", package_options = c("referenced",
  "library", "description"))
}
\arguments{
\item{project_path}{A string representing the path of the project root 
in which the function will look recursively in order to find files that
fit \code{include_pattern}}

\item{include_pattern}{A string representing a regex that matches 
project files in which to look for packages. By default, 
\code{get_packages} looks for all .R and .Rmd files in the current project.}

\item{exclude_pattern}{A string representing a regex that matches 
project files to exclude. By default, 
\code{get_packages} excludes all files found in "tests" folder.}

\item{package_options}{A character vector that represents the method through
  which packages are loaded or referenced. The options are: 
  \code{referenced} for packages referenced by the \code{::} operator, 
  \code{library} for packages loaded using \code{library()} or \code{require()},
\code{description} for packages mentioned in \code{DESCRIPTION} file, and
\code{loaded} for packages already loaded in the current session.}
}
\value{
A data frame containing package information:
\item{package_name}{The name of the package}
\item{requested_by}{The context in which the package was used}
\item{is_base}{Whether package is part of the core R packages}
\item{source}{The source from which the package was installed}
\item{version}{The version of the package, if installed locally}
\item{is_installed}{Whether the package is installed locally}
}
\description{
The function returns a data frame containing information about
  packages that are loaded with \code{library()}, \code{require()}, used
  with \code{::} operator, listed in the DESCRIPTION file,
  and/or already loaded.
}
\examples{
\dontrun{
package_df <- get_packages(
    project_path = '.',
    include_pattern = '\\\\.R$', 
    exclude_pattern = '', 
    package_options = c('referenced'))
}

}
\seealso{
\code{\link{generate_install_file}}
}
