% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{degree}
\alias{degree}
\title{Degree}
\usage{
degree(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of degree values for each node in the network.
If directed network, returns a list of in-degree (inDegree), out-degree (outDegree), and relative influence (relInf)
}
\description{
Computes degree of each node in a network
}
\examples{
A<-TMFG(neoOpen)$A

deg<-degree(A)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
